this.name        = "ups_container"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Container missions of UPS Courier"; 
this.version     = "1.3.7"; 

this.testing = false

this.startUp = function()
{
    if (oolite.compareVersion("1.70") > 0)
    {
        // Oolite version is older than 1.70.
        LogWithClass("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Parcel missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
    }
    this.timer= new Timer(this, this.ups_timed_missionOffers, 1, 0.5)
    this.timer.stop()
    if(worldScripts.TigersTurf) this.pirates = "tigers"; else this.pirates = "ups_pirate";
}

this.shipDockedWithStation = function()
{
        this.ups_missionOffers()
}

this.ups_random = function()
{
    return Math.random() * 0.8 + 0.1;
}

this.ups_randomZ = function()
{
    return Math.random() * 0.6 + 0.2;
}

this.missionScreen = function(messageKey, backGround, choiceKey, shipKey)
{
	mission.setBackgroundImage(backGround);
        mission.showShipModel(shipKey);mission.setMusic()
	mission.showMissionScreen();
	mission.addMessageTextKey(messageKey);
        if (choiceKey) mission.setChoicesKey(choiceKey)
	mission.setBackgroundImage();
}

this.ups_timed_missionOffers = function()
{
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return
    this.timer.stop()
    if (player.docked) this.ups_missionOffers()
}

this.longRangeChart = function()
{
    if(guiScreen == "GUI_SCREEN_LONG_RANGE_CHART")
    {
        if(this.mark) {player.call("removeMissionDestination:", missionVariables.ups_cplanet); this.mark = false}
        else {mission.markSystem(missionVariables.ups_cplanet); this.mark = true}
    }
    else
    {
        this.missionChartTimer.stop()
        player.call("removeMissionDestination:", missionVariables.ups_cplanet)
        this.mark = true // Keep this selected system.
        missionVariables.offering = null
        mission.resetMissionChoice()
        if(player.status == "STATUS_DOCKED") this.ups_missionOffers()
        //without being docked, "player.dockedStation.isMainStation" generates errors in the log.
    }
}

this.ups_missionOffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) {this.timer.start(); return}
    // there might not be a "missionScreenEnded" in future to react uppon, so set up an timer.
    if (player.dockedStation.isMainStation)
    {
        if(missionVariables.ups_container == "BOA")
        {
            if(missionVariables.ups_pcount > 2 && system.government > 3 && player.bounty < 3)
            {
                if(!this.mark) missionVariables.ups_cplanet = Math.round(Math.random()*255)
                if(oolite.compareVersion("1.70") < 0) missionVariables.ups_cplanetname = System.systemNameForID(missionVariables.ups_cplanet) // available in 1.71+
                if(missionVariables.ups_ccount == 0)
                    this.missionScreen("ups_container_1st_offer", "UPS.png", "ups_container_accepted_yesnolook", "boa_ptt")
                else  
                {
                    if(missionVariables.ups_ccount > 1 && 0 > oolite.compareVersion("1.70"))
                    this.missionScreen("ups_container_offer_bis", "UPS.png", "ups_container_accepted_yesnolook", "boa_ptt")
                    else this.missionScreen("ups_container_offer", "UPS.png", "ups_container_accepted_yesnolook", "boa_ptt")
                }
                missionVariables.offering = "UPS_CONTAINER1"
                missionVariables.ups_container_count = 0
                missionVariables.ups_container_award = 0
            }
        }
        if(missionVariables.ups_container == "SEARCHING" && system.government > 1)
        {
            missionVariables.ups_difference = clock.days - missionVariables.ups_timerstart
            if(missionVariables.ups_difference > 30)
            {
                this.missionScreen("ups_container_boa_withdraw", "UPS.png")
                missionVariables.ups_container = "NOT_NOW"
    //          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_cplanet)
                mission.setInstructionsKey()
            }
            if(missionVariables.ups_cplanet == system.ID && !missionVariables.ups_cbriefing && system.countShipsWithRole("boa_ptt") == 0)
            {
                this.missionScreen("ups_container_missed", "UPS.png")
                mission.setInstructionsKey("ups_container_missed_small")
    //          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_cplanet)
                missionVariables.ups_cplanet = missionVariables.ups_bplanet
                missionVariables.ups_cplanetname = missionVariables.ups_bplanetname
                mission.markSystem(missionVariables.ups_cplanet)
                missionVariables.ups_cbriefing = "YES"
            }
        }
        if(missionVariables.ups_container == "FOUND" && system.government > 1)
        {
            missionVariables.ups_container = "NOT_NOW"
//          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_cplanet)
            mission.setInstructionsKey()
            missionVariables.ups_container_award = missionVariables.ups_container_award // remove trailing zeros
            if (missionVariables.ups_container_count == 0)
            {
                if(missionVariables.ups_closecontact == "YES")
                {this.missionScreen("ups_container_destroyed0", "UPS.png"); player.credits += 100}
                else {this.missionScreen("ups_container_destroyed0a", "UPS.png")}
            }
            else
            {
                if (missionVariables.ups_container_count == 5)
                {
                    missionVariables.ups_container_award += 1000
                    this.missionScreen("ups_container_destroyed2", "UPS.png")
                }
                else {this.missionScreen("ups_container_destroyed1", "UPS.png")}
                missionVariables.ups_ccount++
                player.credits +=  missionVariables.ups_container_award
            }
            missionVariables.ups_target = "hostile Boa"
            missionVariables.ups_closecontact = null
            missionVariables.ups_container_award = null
            missionVariables.ups_container_count = null
            missionVariables.ups_bplanet = null
            missionVariables.ups_bplanetname = null
            missionVariables.ups_b2planet = null
            missionVariables.ups_b2planetname = null
   
        }
        if(missionVariables.ups_container == "LOGGING")
        {
            missionVariables.ups_difference = clock.days - missionVariables.ups_timerstart
            if(system.government > 3 && player.bounty < 3 && missionVariables.ups_difference > 8)
            {
                if(missionVariables.ups_c1count == 0)
                this.missionScreen("ups_container_1st_logging", "UPS.png", "ups_container_accepted2_yesnolook", "python_ptt")
                else this.missionScreen("ups_container_logging", "UPS.png", "ups_container_accepted2_yesnolook", "python_ptt")
                missionVariables.offering = "UPS_CONTAINER2"
                missionVariables.ups_container_count = 0
                missionVariables.ups_container_award = 0
            }
        }
        if(missionVariables.ups_container == "FOUND2" && system.government > 1)
        {
            missionVariables.ups_container = "NOT_NOW"
//          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_cplanet)
            mission.setInstructionsKey()
            missionVariables.ups_container_award = missionVariables.ups_container_award // remove trailing zeros
            if(missionVariables.ups_container_count == 0)
            {this.missionScreen("ups_container_destroyed02", "UPS.png"); player.credits += 100}
            else
            {
                if(missionVariables.ups_container_count == 5)
                {
                    missionVariables.ups_container_award += 1000
                    this.missionScreen("ups_container_destroyed22", "UPS.png")
                }
                else
                {
                    this.missionScreen("ups_container_destroyed12", "UPS.png")
                }
                missionVariables.ups_c1count += 1
                player.credits += missionVariables.ups_container_award
            }
            missionVariables.ups_container_award = null
            missionVariables.ups_container_count = null
            if(missionVariables.ups_c1count > 4 && !missionVariables.TL_FOR_EQ_UPS_PRIVATE_ESCORT)
            {missionVariables.ups_container_message = 2}
            missionVariables.ups_target = "pirate python"
        }
        if(missionVariables.ups_container == "FOUND2" && system.government < 2)
        {
            if(missionVariables.ups_container_count == 0) mission.setInstructionsKey("ups_containers_small2b")
            else mission.setInstructionsKey("ups_containers_small2a")
        }
        if(missionVariables.ups_container == "LOGGING2")
        {
            missionVariables.ups_difference = clock.days - missionVariables.ups_timerstart
            if(system.government > 3 && player.bounty < 3 && missionVariables.ups_difference > 8)
            {
                if(missionVariables.ups_cloaking == "YES")
                {
                    if(missionVariables.ups_c2count == 0)
                    this.missionScreen("ups_container_1st_logging2cloaked", "UPS.png", "ups_container_accepted3_yesnolook")
                    else this.missionScreen("ups_container_logging2cloaked", "UPS.png", "ups_container_accepted3_yesnolook")

                }
                else
                {
                    if(missionVariables.ups_c2count == 0)
                    this.missionScreen("ups_container_1st_logging2", "UPS.png", "ups_container_accepted3_yesnolook")
                    else this.missionScreen("ups_container_logging2", "UPS.png", "ups_container_accepted3_yesnolook")
                }
                missionVariables.offering = "UPS_CONTAINER3"
                missionVariables.ups_container_award = 0
                missionVariables.ups_container_count = 0
            }
        }
        if(missionVariables.ups_container == "SEARCHING3" && missionVariables.ups_c2count > 2)
        {
            if(!missionVariables.ups_switch) missionVariables.ups_switch = missionVariables.ups_c2count
            else missionVariables.ups_switch += missionVariables.ups_c2count
            if((missionVariables.ups_switch - Math.random()*100) > 30)
            {
                missionVariables.ups_container = "SEARCHING4"
                missionVariables.ups_switch = null
                missionVariables.ups_timerstart = clock.days
            }
        }
        if(missionVariables.ups_container == "FOUND3" && system.government > 1)
        {
            missionVariables.ups_container = "NOT_NOW"
//          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_cplanet)
            this.missionScreen("ups_container_base_destroyed", "UPS.png")
            mission.setInstructionsKey()
            if(!missionVariables.ups_c2count) missionVariables.ups_c2count = 0
            missionVariables.ups_c2count++
            player.credits += 2000
            missionVariables.ups_switch = null
            missionVariables.ups_target = "pirate base"
        }
        if(missionVariables.ups_container == "SEARCHING4" && system.government > 3)
        {
            missionVariables.ups_difference = clock.days - missionVariables.ups_timerstart
            if(missionVariables.ups_difference > 15)
            {
                this.missionScreen("ups_container_qbomb", "UPS.png")
                missionVariables.ups_timerstart = clock.days
            }
        }
        if(missionVariables.ups_container == "FOUND4" && system.government > 1)
        {
            missionVariables.ups_container = "NOT_NOW"
//          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_cplanet)
            this.missionScreen("ups_container_base2_destroyed", "UPS.png")
            mission.setInstructionsKey()
            if(!missionVariables.ups_c3count) missionVariables.ups_c3count = 0
            missionVariables.ups_c3count++
            player.credits += 4000
            if(missionVariables.ups_c3count == 1) missionVariables.ups_container_message = 1
            if(missionVariables.ups_c3count > 1 && player.score > 6400 && !missionVariables.TL_FOR_EQ_UPS_UNIVERSAL_SCANNER)
            missionVariables.ups_container_message = 3
            missionVariables.ups_switch = null
            missionVariables.ups_target = "guarded pirate base"
        }
        if(missionVariables.ups_container == "JOINED_PIRATES" && system.government > 3 && Math.random() < 0.2)
        {
            this.missionScreen("ups_container_piratelife", "UPS.png")
            missionVariables.ups_container = "JOINED_PIRATES2"
            player.bounty += 1000
            mission.setInstructionsKey()
//          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_cplanet)
        }
        if(missionVariables.ups_container == "SPILLAGE" && system.government > 3)
        {
            this.missionScreen("ups_container_scattered_1", "UPS.png")
            missionVariables.ups_container = "SPILLAGE2"
            missionVariables.ups_cplanet = system.ID
            mission.markSystem(missionVariables.ups_cplanet)
            mission.setInstructionsKey("ups_container_scattered_small")
        }
        if(missionVariables.ups_container == "SPILLAGE3" && missionVariables.ups_cplanet == system.ID)
        {
            if(missionVariables.ups_container_count > 0)
            {
                missionVariables.ups_container_award = missionVariables.ups_container_award // remove trailing zeros
                this.missionScreen("ups_container_scattered_2", "UPS.png")
                missionVariables.ups_difference = system.countShipsWithRole("ups-container") // ups_difference =displaytext
                if(missionVariables.ups_difference > 0)
                {
                   mission.addMessageTextKey("ups_container_scattered_3")
                    mission.setInstructionsKey("ups_container_scattered_small2")
                }
                else
                {
                    missionVariables.ups_container = "NOT_NOW"
        //          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
                    player.call("removeMissionDestination:", missionVariables.ups_cplanet)
                    mission.setInstructionsKey()
                    missionVariables.ups_cplanet = null
                }
                player.credits += missionVariables.ups_container_award
                missionVariables.ups_container_award = 0
                missionVariables.ups_container_count = 0
                missionVariables.ups_total_container_count = 0
            }
        }
        if(missionVariables.ups_container_message > 0 && guiScreen != "GUI_SCREEN_MISSION")
        {
            if(missionVariables.ups_container_message == 1)
            {
                this.missionScreen("ups_container_the_end", "UPS.png")
                missionVariables.offering = null
                missionVariables.ups_container_message = null
            }
            if(missionVariables.ups_container_message == 2 && system.government > 1 && Math.random() > 0.9)
            {
                this.missionScreen("ups_container_message2", "UPS.png")
                missionVariables.TL_FOR_EQ_UPS_PRIVATE_ESCORT = 3
                missionVariables.ups_container_message = null
            }
            if(missionVariables.ups_container_message == 3 && system.government > 1 && system.techLevel > 11 && Math.random() > 0.5)
            {
                this.missionScreen("ups_container_message3", "UPS.png")
                missionVariables.TL_FOR_EQ_UPS_UNIVERSAL_SCANNER = 12
                missionVariables.ups_container_message = null
            }
        }
        if(player.hasEquipment("EQ_UPS_POLICE_SCANNER"))
        {
            if((missionVariables.ups_container == "NO" || missionVariables.ups_container =="NOT_NOW") && system.government > 1)
            {
                player.removeEquipment("EQ_UPS_POLICE_SCANNER")
                missionVariables.ups_scannertimer = null
                missionVariables.ups_galcop_punishment += 40
                this.missionScreen("ups_container_scannerremoved", "UPS.png")
                player.bounty += missionVariables.ups_galcop_punishment
            }
        }
        if(player.hasEquipment("EQ_UPS_IDCLEANER"))
        {
            if((missionVariables.ups_container == "NO" || missionVariables.ups_container =="NOT_NOW") && system.government > 1)
            {
                player.removeEquipment("EQ_UPS_IDCLEANER")
                missionVariables.ups_scannertimer = null
                missionVariables.ups_galcop_punishment += 15
                this.missionScreen("ups_container_scannerremoved", "UPS.png")
                player.bounty += missionVariables.ups_galcop_punishment
            }
        }
    }
    if (player.dockedStation.shipDescription == "Pirate Rock")
    {
        if(missionVariables.ups_ecount > 1 && (missionVariables.ups_container == "LOGGING" || missionVariables.ups_container == "LOGGING2" || missionVariables.ups_container == "SEARCHING3" || missionVariables.ups_container == "SEARCHING4"))
        {
            this.missionScreen("ups_container_pirateoffer", null, "ups_container_pirateoffer_yesno")
            missionVariables.offering = "UPS_CONTAINER_PIRATE"
        }
    }
    if(missionVariables.ups_container == "JOINED_PIRATES" ||missionVariables.ups_container == "JOINED_PIRATES2")
    {
        if(system.government == 0)
        {
            missionVariables.TL_FOR_EQ_UPS_POLICE_SCANNER = 3
            missionVariables.TL_FOR_EQ_UPS_IDCLEANER = 5
        }
        else
        {
            missionVariables.TL_FOR_EQ_UPS_POLICE_SCANNER = null
            missionVariables.TL_FOR_EQ_UPS_IDCLEANER = null
        }
    }
}

this.ups_choiceEvaluation = function()
{
    if(!player.docked) return;
    if (missionVariables.offering == "UPS_CONTAINER1")
    {
        this.mark = false
        if(mission.choice == "YESCon")
        {
            mission.resetMissionChoice()
            if(missionVariables.ups_ccount > 1 && oolite.compareVersion("1.70") < 0)
                mission.setInstructionsKey("ups_containers_small_bis") 
            else
                mission.setInstructionsKey("ups_containers_small") 
            mission.markSystem(missionVariables.ups_cplanet) 
            missionVariables.ups_container = "SEARCHING" 
            missionVariables.offering = null
            missionVariables.ups_timerstart = clock.days 
            missionVariables.ups_b2planet = system.ID
            missionVariables.ups_b2planetname = ExpandDescription("[%H]") 
        }
        else
        {
            if(mission.choice == "LOOKCon")
            {
                player.call("setGuiToLongRangeChartScreen")
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOCon")
                {
                    mission.resetMissionChoice()
                    missionVariables.ups_container = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "UPS_CONTAINER2")
    {
        this.mark = false
        if(mission.choice == "YESCon")
        {
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_containers_small2") 
            mission.markSystem(missionVariables.ups_cplanet) 
            missionVariables.ups_container = "SEARCHING2" 
            missionVariables.offering = null
            }
        else
        {
            if(mission.choice == "LOOKCon")
            {
                player.call("setGuiToLongRangeChartScreen")
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOCon")
                {
                    mission.resetMissionChoice()
                    missionVariables.ups_container = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "UPS_CONTAINER3")
    {
        this.mark = false
        if(mission.choice == "YESCon")
        {
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_containers_small4") 
            mission.markSystem(missionVariables.ups_cplanet) 
            missionVariables.ups_container = "SEARCHING3" 
            missionVariables.offering = null
        }
        else
        {
            if(mission.choice == "LOOKCon")
            {
                player.call("setGuiToLongRangeChartScreen")
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOCon")
                {
                    mission.resetMissionChoice()
                    missionVariables.ups_container = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "UPS_CONTAINER_PIRATE")
    {
        if(mission.choice == "YESCon")
        {
            player.credits += 5000
            mission.resetMissionChoice()
            this.missionScreen("ups_container_pirateoffer2")
            missionVariables.offering = "UPS_CONTAINER_PIRATE2"
            missionVariables.ups_container = "JOINED_PIRATES"
            missionVariables.ups_scannertimer = clock.days
        }
        else
        {
            if (mission.choice == "NOCon")
            {
                mission.resetMissionChoice()
                missionVariables.offering = null
                player.launch()
                player.commsMessage("Yes, destroy the pirates.", 5)
                if(player.hasEquipment("EQ_CLOAKING_DEVICE"))
                {
                    player.removeEquipment("EQ_CLOAKING_DEVICE")
                    player.awardEquipment("EQ_CRIPPLED_CLOAKING")
                    missionVariables.ups_cloaking = "CRIPPLED"
                }
            } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
    if (missionVariables.offering == "UPS_CONTAINER_PIRATE2" && guiScreen != "GUI_SCREEN_MISSION")
    {
        this.missionScreen("ups_container_pirateoffer2a")
        missionVariables.offering = "UPS_CONTAINER_PIRATE3"
    }
    if (missionVariables.offering == "UPS_CONTAINER_PIRATE3" && guiScreen != "GUI_SCREEN_MISSION")
    {
        this.missionScreen("ups_container_pirateoffer2b")
        missionVariables.offering = null
    }
}

/*
this.missionChoiceWasReset = function(oldMissionChoice)
{
    Added pro memory. This event will be avoilable starting from version 1.71
    Should be used in a combo with this.missionScreenEnded = function()
}
*/

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    this.ups_choiceEvaluation()
    this.ups_missionOffers()
}

this.missionChoiceWasReset = function() // available in 1.71
{
    if(!player.docked) return;
    this.ups_missionOffers()
}

this.shipExitedWitchspace = function()
{
    this.setUpShips();
    if(missionVariables.ups_container == "NOT_NOW" && Math.random() < 0.1) missionVariables.ups_container = "NO"
    if(missionVariables.ups_container == "NO")
    {
        if(system.government > 3 && Math.random() < 0.05)
        {
            if(missionVariables.ups_ccount < 10 || Math.random() < 0.25)
            missionVariables.ups_container = "BOA"
        }
        if(missionVariables.ups_container == "NO" && Math.random() < 0.15 && !system.gonenova && missionVariables.ups_ccount > 1 && system.government < 2)
        {
            if(missionVariables.ups_c1count > 10 && Math.random() > 0.33)
            {if(Math.random() > 0.50) missionVariables.ups_container ="SPILLAGE"}
            else
            {
                missionVariables.ups_container = "LOGGING"
                missionVariables.ups_cplanet = system.ID
                missionVariables.ups_planetname = ExpandDescription("[%H]")
                missionVariables.ups_timerstart = clock.days
            }
        }
        if(missionVariables.ups_container == "NO" && Math.random() < 0.2 && !system.gonenova && missionVariables.ups_c1count > 1 && system.government == 0)
        {
            if(missionVariables.ups_c2count < 10 || Math.Random() < 0.33)
            {
                missionVariables.ups_container = "LOGGING2"
                missionVariables.ups_cplanet = system.ID
                missionVariables.ups_planetname = ExpandDescription("[%H]")
                missionVariables.ups_timerstart = clock.days
            }
        }
        if(missionVariables.ups_container == "NO" && Math.random() < 0.04 && player.credits > 10000 && system.techLevel < 6 && missionVariables.ups_tcount > 2 && system.ID > -1)
        {
            player.fuelLeakRate = 20
            player.consoleMessage("Danger: Fuelleak!", 4)
            if(worldScripts.transportSchedule || worldScripts.transportschedule !== undefined)  // has Transports.OXP installed
                system.legacy_addShips("ups-womafueltanker", 1); else system.legacy_addShips("ups-fueltanker", 1)
            system.legacy_addShipsAt("sunskim-trader", 2, "swu", 0, 0, this.ups_random())
            system.legacy_addShipsAt("sunskim-trader", 2, "swu", 0, 0, this.ups_random())
            system.legacy_addShipsAt("ups-sunskim", 2, "swu", 0, 0, this.ups_random())
            system.legacy_addShipsAt("ups-sunskim", 2, "swu", 0, 0, this.ups_random())
            system.legacy_addShipsAt("ups-sunskim", 2, "swu", 0, 0, this.ups_random())
        }
    }
    else
    {
        if(missionVariables.ups_container == "SEARCHING" || missionVariables.ups_container == "SEARCHING2" || missionVariables.ups_container == "SEARCHING3" || missionVariables.ups_container == "SEARCHING4")
        {
            if(player.score > 1000 && system.ID > -1)
            {
                system.legacy_addSystemShips("ups_pirate", 4, this.ups_random())
                system.legacy_addSystemShips(this.pirates, 4, this.ups_random())
                system.legacy_addSystemShips("trader", 1, this.ups_random())
            }
            if(missionVariables.ups_container == "SEARCHING")
            {
                missionVariables.ups_bplanet = missionVariables.ups_b2planet
                missionVariables.ups_bplanetname = missionVariables.ups_b2planetname
                missionVariables.ups_b2planet = system.ID
                missionVariables.ups_b2planetname = ExpandDescription("[%H]")
            }
        }
        if((missionVariables.ups_container == "JOINED_PIRATES" || missionVariables.ups_container == "JOINED_PIRATES2") && system.ID > -1)
        {
            system.legacy_addSystemShips("trader", (8 - system.economy), 0.25)
            if(system.economy < 4) system.legacy_addSystemShips("upstrader", 1, this.ups_random())
            if(system.economy < 2)
            {
                system.legacy_addSystemShips("upstrader", 2, this.ups_random())
                system.legacy_addSystemShips("upstrader", 1, this.ups_random())
            }
            if(system.government > 4)
            {
                system.legacy_addSystemShips("police", 3, this.ups_random())
                system.legacy_addSystemShips("police", 3, this.ups_random())
            }
             if(system.government == 0 && Math.random() < 0.05)
            {
                let baseposition = this.ups_random()
                system.legacy_addSystemShips("pirate-upsbase", 1, baseposition)
                missionVariables.ups_asteroids = 5
                system.legacy_addSystemShips("asteroid", 8, baseposition)
                missionVariables.ups_asteroids = null
                system.legacy_addSystemShips("ups_pirate", 2, (baseposition - 0.15))
                if(player.hasEquipment("EQ_CLOAKING_DEVICE"))
                {
                    player.consoleMessage("Cloaking jammed", 3)
                    player.removeEquipment("EQ_CLOAKING_DEVICE")
                    player.awardEquipment("EQ_CRIPPLED_CLOAKING")
                    missionVariables.ups_cloaking = "CRIPPLED"
                }
            }
        }
        if(missionVariables.ups_container == "SPILLAGE3")
        {
            if(missionVariables.ups_container_count > 0)
            {} // nothing
            else
            {
                missionVariables.ups_container = "NOT_NOW"
                if(missionVariables.ups_cplanet)
                {
        //          mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
                    player.call("removeMissionDestination:", missionVariables.ups_cplanet)
                    missionVariables.ups_cplanet = null
                    missionVariables.ups_container_award = null
                    missionVariables.ups_container_count = null
                    missionVariables.ups_total_container_count = null
                }
            }
        }
        if(missionVariables.ups_target)
        {
            if(Math.random() < 0.20) missionVariables.ups_target = null
            else
            {
            let happyTraders = system.shipsWithPrimaryRole("trader", player);
            for (let i=0; i<happyTraders.length;i++)
                if(happyTraders[i]) //could have already been destroyed or not present
                {
                    if(happyTraders[i].AI == "route1traderAI.plist")
                    happyTraders[i].switchAI("upsHailingTraderAI.plist")
                }
            }
        }
    }
	// galaxyNumber is GLOBAL and may change to player.galaxyNumber  in future!!!
    if(missionVariables.ups_galaxy != galaxyNumber)
    {
        //reset missions on switching galaxy
        missionVariables.ups_container = "NOT_NOW"
//      mission.unmarkSystem(missionVariables.ups_cplanet)  // this command crashes Oolite 1.70!
        player.call("removeMissionDestination:", missionVariables.ups_cplanet)
        missionVariables.ups_cplanet = null
        missionVariables.ups_cbriefing = null
        missionVariables.ups_container_count = null
        missionVariables.ups_total_container_count = null
        missionVariables.ups_bplanet = null
        missionVariables.ups_bplanetname = null
        missionVariables.ups_b2planet = null
        missionVariables.ups_b2planetname = null
        mission.setInstructionsKey()
        missionVariables.TL_FOR_EQ_UPS_POLICE_SCANNER = null
        missionVariables.TL_FOR_EQ_UPS_IDCLEANER = null
        // resetting missionsDescriptions must be done in their own mission so flag them
        missionVariables.ups_docsreset = "YES" 
        missionVariables.ups_parcelreset = "YES" 
        if (missionVariables.ups_sun) missionVariables.ups_sunreset = "YES"
        if (missionVariables.ups_slaves) missionVariables.ups_slavesreset = "YES"
        missionVariables.ups_galaxy = galaxyNumber
    }
    if(player.hasEquipment("EQ_UPS_IDCLEANER"))
    {
        if(!missionVariables.ups_status_backup && system.government == 0)
        {
            missionVariables.ups_status_backup = player.bounty
            player.bounty = 0
        }
        if(missionVariables.ups_status_backup && missionVariables.ups_status_backup > -1 && system.government > 0)
        {
            missionVariables.ups_status_backup += player.bounty
            player.bounty = missionVariables.ups_status_backup
            missionVariables.ups_status_backup = null
        }
    }
    if(Math.random() < 0.04 && missionVariables.ups_c1count > 2 && system.government > 3) 
    {
        system.legacy_addSystemShips("derelict_ptt", 1, Math.random())
    }
    if(system.isInterstellarSpace)
    {
        if(player.credits > 10000 && missionVariables.ups_tcount > 2 && player.fuel < 2 && Math.random() < 0.5)
        if(worldScripts.transportSchedule || worldScripts.transportschedule !== undefined)  // has Transports.OXP installed
        system.legacy_addSystemShips("ups-womafueltanker2", 1, 0.3)
        else system.legacy_addSystemShips("ups-fueltanker2", 1, 0.3)
    }
}

/*
this.playerEnteredNewGalaxy(newGalaxyNumber)
{
  new event introduced in version 1.71. Placed here pro memory to be used for resetting things when 1.70 gets outdated.
}
*/

this.setUpShips = function()
{
    let z_axis = 0;
    if(missionVariables.ups_cloaking == "CRIPPLED")
    {
        player.removeEquipment("EQ_CRIPPLED_CLOAKING")
        player.awardEquipment("EQ_CLOAKING_DEVICE")
        missionVariables.ups_cloaking = "YES"
    }
    if(missionVariables.ups_container == "SEARCHING" && missionVariables.ups_cplanet == system.ID)
    {
        z_axis = this.ups_randomZ()
        if(system.countShipsWithRole("boa_ptt") == 0)
        {
            system.legacy_addShipsAtPrecisely("boa_ptt", 1, "wpu", 0, 0, z_axis)
            if(system.government > 5) system.legacy_addShipsAtPrecisely("pirate-upsEscort", 8, "wpu", 0, 0, z_axis)
            if(system.government== 0) system.legacy_addShipsAtPrecisely("pirate2-upsEscort", 8, "wpu", 0, 0, z_axis)
        }
        missionVariables.ups_cbriefing = null
        missionVariables.ups_closecontact = "NO"
    }
    if(missionVariables.ups_container == "SEARCHING2" && missionVariables.ups_cplanet == system.ID)
    {
        if(system.countShipsWithRole("python_ptt") == 0)
        system.legacy_addSystemShips("python_ptt", 1, this.ups_random())
    }
    if(missionVariables.ups_container == "SEARCHING3" || missionVariables.ups_container == "JOINED_PIRATES" || missionVariables.ups_container == "JOINED_PIRATES2")
    {
        if(missionVariables.ups_cplanet == system.ID)
        {
            if(system.countShipsWithRole("pirate-upsbase") == 0)
            {
                missionVariables.ups_asteroids = 5
                system.legacy_addSystemShips("pirate-upsbase", 1, 0.3)
                system.legacy_addSystemShips("asteroid", 8, 0.3)
                system.legacy_addSystemShips("police", 2, 0.15)
                system.legacy_addSystemShips("ups_pirate", 2, 0.15)
                missionVariables.ups_asteroids = null
            }
            if(player.hasEquipment("EQ_CLOAKING_DEVICE") && !this.testing)  ///// testing
            {
                player.consoleMessage("Cloaking jammed", 3)
                player.removeEquipment("EQ_CLOAKING_DEVICE")
                player.awardEquipment("EQ_CRIPPLED_CLOAKING")
                missionVariables.ups_cloaking = "CRIPPLED"
            }
        }
    }
    if(missionVariables.ups_container == "SEARCHING4")
    {
        if(missionVariables.ups_cplanet == system.ID)
        {
            if(system.countShipsWithRole("pirate-upsbase2") == 0)
            {
                missionVariables.ups_asteroids = 5
                system.legacy_addSystemShips("pirate-upsbase2", 1, 0.3)
                system.legacy_addSystemShips("asteroid", 8, 0.3)
                system.legacy_addSystemShips("upsdefender", 8, 0.3)
                system.legacy_addSystemShips("police", 2, 0.15)
                system.legacy_addSystemShips("ups_pirate", 2, 0.15)
                system.legacy_addSystemShips("this.pirates", missionVariables.ups_c3count, 0.3)
                missionVariables.ups_asteroids = null
                missionVariables.ups_timerstart = clock.days
            }
            if(player.hasEquipment("EQ_CLOAKING_DEVICE") && !this.testing)
            {
                player.consoleMessage("Cloaking jammed", 3)
                player.removeEquipment("EQ_CLOAKING_DEVICE")
                player.awardEquipment("EQ_CRIPPLED_CLOAKING")
                missionVariables.ups_cloaking = "CRIPPLED"
            }
        }
    }
    if(player.hasEquipment("EQ_UPS_PRIVATE_ESCORT"))
    {
        if(!missionVariables.ups_private_escorts)
        {
            missionVariables.ups_private_escorts = 8
            missionVariables.ups_private_escorts_date = clock.days
        }
        if((clock.days - missionVariables.ups_private_escorts_date) < 11)
        {
            if(system.countShipsWithRole("ups_private_escort") == 0)
            {
                if(player.withinStationAegis)
                system.legacy_addSystemShips("ups_private_escort", missionVariables.ups_private_escorts, 1)
                else system.legacy_addSystemShips("ups_private_escort", missionVariables.ups_private_escorts, 0)
            }
        }
        else
        {
            let myEscorts = system.shipsWithRole("ups_private_escort");
            for (let i=0; i < missionVariables.ups_private_escorts; i++)
                if(myEscorts[i]) myEscorts[i].AIState = "CANCEL_CONTRACT";
            missionVariables.ups_private_escorts = null
            missionVariables.ups_private_escorts_date = null
            player.removeEquipment("EQ_UPS_PRIVATE_ESCORT")
            player.consoleMessage(ExpandDescription("[ups_escort_expired]"), 6)
        }
    }
}

this.ups_scanners = function()
{
    if (player.status == "STATUS_DOCKED")  { this.scannertimer.stop() ;return}
    if(player.hasEquipment("EQ_UPS_POLICE_SCANNER"))
    {
        player.comsoleMessage("scanned: " + (system.countShipsWithRole("police") + system.countShipsWithRole("wingman") + system.countShipsWithRole("interceptor")) +" GalCop ships, " + system.countShipsWithRole("hunter") + " hunters " + (system.countShipsWithRole("sunskim-trader") + system.countShipsWithRole("trader")) + " traders and " + system.countShipsWithRole("escort") + "escorts.", 6)
        if(system.government > 0)
        {
            player.bounty++
            if(Math.random() < 0.06)
            {
                system.legacy_addSystemShips("police", 1, this.ups_random()) 
                system.legacy_addSystemShips("interceptor", 1, this.ups_random())
                if(system.government > 5) system.legacy_addSystemShips("police", 1, 1)
            }
        }
    }
    if(player.hasEquipment("EQ_UPS_UNIVERSAL_SCANNER"))
    {
        player.consoleMessage("scanned: " + (system.countShipsWithRole("pirate") + system.countShipsWithRole("ups_pirate")) + " pir, " + (system.entitiesWithScanClass("CLASS_POLICE").length) + " pol, " + system.countShipsWithRole("hunter") + " hunt, " + (system.countShipsWithRole("sunskim-trader") + system.countShipsWithRole("trader")) + " trad, " + system.countShipsWithRole("escort") + " esc, " + system.entitiesWithScanClass("CLASS_THARGOID").length + " tharg.", 6)
    }
}

this.shipLaunchedFromStation = function()
{
    this.setUpShips()
    if(missionVariables.offering) {missionVariables.offering = null; this.offerWarning = true}
    if(mission.choice && mission.choice != "") {mission.resetMissionChoice();this.choiceWarning = true}
    if(missionVariables.ups_container == "SPILLAGE2")
    {
        missionVariables.ups_container = "SPILLAGE3" 
        missionVariables.ups_container_count = 0 
        missionVariables.ups_total_container_count = 0 
        system.legacy_addSystemShips("ups-scavenger", 1, this.ups_random()) 
        system.legacy_addSystemShips("ups-scavenger", 1, this.ups_random()) 
        system.legacy_addSystemShips("ups-scavenger", 1, this.ups_random()) 
        system.legacy_addSystemShips("ups-scavenger", 1, this.ups_random()) 
        system.legacy_addSystemShips("ups-container", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-container", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-container", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-container", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-cargopod-u", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-cargopod-u", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-cargopod-u", 5, this.ups_random()) 
        system.legacy_addSystemShips("ups-cargopod-u", 5, this.ups_random()) 
     }
     if(player.hasEquipment("EQ_UPS_UNIVERSAL_SCANNER") || player.hasEquipment("EQ_UPS_POLICE_SCANNER"))
     {
        if(this.scannertimer)
        this.scannertimer.start()
        else
        this.scannertimer = new Timer(this, this.ups_scanners, 20, 20)
     }
}